//
//  MPSView.h
//  MPServices
//
//  Created by Oleksii Dykan on 6/12/15.
//  Copyright (c) 2015 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

IB_DESIGNABLE
@interface MPSView : NSView

@property (nonatomic, copy) IBInspectable NSString *ninePartImageName;
@property (nonatomic, copy) IBInspectable NSString *threePartImageName;
@property (nonatomic, copy) IBInspectable NSString *backgroundImageName;
@property (nonatomic, strong) IBInspectable NSColor *backgroundColor;
@property (nonatomic, assign) IBInspectable CGFloat cornerRadius;

@property (nonatomic, strong) IBInspectable NSColor *borderColor;
@property (nonatomic, assign) IBInspectable CGFloat borderWidth;

/// Bundle identifier to use images from other bundles. Default value - nil for main bundle
@property (nonatomic, copy) IBInspectable NSString *bundleIdentifier;

- (void)commonInit;

/// For subclassing purposes
- (void)drawNinePartImage;
- (void)drawThreePartImage;
- (void)drawBackgroundImage;
- (void)drawBackgroundColor;
- (void)drawBorder;

@end
